# Бинарный поиск (алгоритм "разделяй и властвуй")

#### Постановка задачи

Дан остортированный массив из `n` элементов. Написать функцию поиска индекса заданного (целевого) элемента.

#### Подход

- Поиск массива путем многократного деления массива на половины.
- Изначально рассмотрим фактический массив и выберем элемент в среднем индексе.
- Сохраняем нижний индекс (0) и верхний индекс (длина массива).
- Если элемент равен целевому элементу, то возвращаем индекс.
- Если элемент больше целевого элемента, то рассматриваем только левую половину массива (нижний индекс = 0, верхний индекс = `middle - 1`).
- Если элемент меньше целевого элемента, то рассматриваем только правую половину массива (нижний индекс = `middle + 1`, верхний индекс = длина массива).
- Возвращаем `-(индекс вставки + 1)`, если целевой элемент не найден в массиве (если нижний индекс больше или равен верхнему индексу). Некоторые более простые реализации просто возвращают `-1`, если элемент не найден. Смещение 1 должно быть добавлено, так как индекс вставки может быть `0` (искомое значение может быть меньше всех элементов в массиве). Поскольку индексация начинается с `0`, это должно быть отличимо от случая, когда целевой элемент имеет индекс `0`.

#### Временная сложность

- O(log n) - в худшем случае;
- O(1) - в лучшем случае (если средний элемент изначального массива является целевым элементом).

##### Пространственная сложность

- O(1) - для итеративного подхода;
- O(1) - для рекурсивного подхода если используется оптимизация хвостовых вызовов, `O(log n)` из-за стека вызовов рекурсии в противном случае.

#### Пример

```python
arr = [1,2,3,4,5,6,7]  

target = 2
```

Изначально элемент в среднем индексе - `4`, который больше `2`. Поэтому мы ищем левую половину массива, т. е. `[1,2,3]`.

Здесь мы находим средний элемент, равный целевому элементу, поэтому возвращаем его индекс, т. е. `1`.

```
target = 9
```

#### Ссылки на реализации алгоритма

- [Java](https://github.com/TheAlgorithms/Java/blob/master/src/main/java/com/thealgorithms/searches/BinarySearch.java)
- [C++](https://github.com/TheAlgorithms/C-Plus-Plus/blob/master/search/binary_search.cpp)
- [Python](https://github.com/TheAlgorithms/Python/blob/master/searches/binary_search.py)
- [C-Sharp](https://github.com/TheAlgorithms/C-Sharp/blob/master/Algorithms/Search/BinarySearcher.cs)
- [C](https://github.com/TheAlgorithms/C/blob/master/searching/binary_search.c)

#### Видео обзоры

#### Визуальное представление

- [Tute Board](https://boardhub.github.io/tute/?wd=binarySearchAlgo2)
